<?php

declare(strict_types=1);

namespace App\Entity\Label;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'system_labels')]
#[ORM\Entity]
class SystemLabel
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, unique: true, nullable: false)]
    public string $label;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::TEXT, nullable: true)]
    public string $description;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: SystemLabelDeviceMap::class, mappedBy: 'systemLabel', cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devices;

    /**
     * Label constructor
     */
    public function __construct() {

        $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getLabel(): string{

        return $this->label;

    }

    public function setLabel(mixed $label): void {

        $this->label = $label;

    }

}