<?php

declare(strict_types=1);

namespace App\DataTable;

use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Column\LinkColumn;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class DataChangeLogDatatable
 * @package App\Datatables
 */
final class DataChangeLogDatatable extends BaseDatatable
{

    protected string $entity = \App\Entity\DataChangeLog\DataChangeLog::class;
    protected string $name = 'data_change_log_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        $atomTypes = $options['atomTypes'];

        parent::buildDatatable($options);

        $this->options->setOrder([0, 'desc']);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('atom.name', Column::class, array(
                'title' => 'Metric',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => array(SelectFilter::class, array(
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($atomTypes, 'name', 'name'),
                    'cancel_button' => true,
                ))
            ))
            ->add('device.devId', LinkColumn::class, array(
                'title' => 'Device Id',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'route' => 'admin_devices_detail',
                'route_params' => function($row) {
                    return array(
                        'deviceId' => $row['device']['id'],
                    );
                },
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('device.name', Column::class, array(
                'title' => 'Device Name',
                'width' => '100%;',
                'default_content' => 'None',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                )))
            ->add('valueTxt', Column::class, array(
                'title' => 'Value',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('time', DateTimeColumn::class, array(
                'title' => 'Created',
                'width' => '100%;',
                'searchable' => true,
                'filter' => array(DateRangeFilter::class, array(
                    'cancel_button' => true,
                )),
                'date_format' => self::DATETIME_FORMAT,
            ))

        ;
    }

}