<?php

namespace App\DataTable;

use App\Entity\Tool\SimCard;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\LinkColumn;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class LabelDatatable
 * @package App\Datatables
 */
class SimCardDatatable extends BaseDatatable
{

    protected string $entity = SimCard::class;
    protected string $name = 'sim_cards_datatable';

    /**
     * @param array $options
     * @throws \Exception
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $devices = $options['devices'];

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/tool/addSimCard.js.twig',
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addSimCard',
                        'text' => '<i class=\"fa fa-plus\"></i> Add SIM Card',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('iccid', Column::class,[
                'title' => 'Iccid',
                'width' => '100%;',
                'filter' => [
                    TextFilter::class,[
                        'cancel_button' => true,
                    ],
                ]
            ])
            ->add('msisdn', Column::class, [
                'title' => 'Msisdn',
                'width' => '100%;',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])

            ->add('label', Column::class, array(
                'title' => 'Label',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                if(true === $this->isAdmin()) {
                                    return true;
                                };
                            }

                            return false;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))

            ->add('deviceUser.devId', LinkColumn::class, array(
                'title' => 'Dev.',
                'default_content' => '',
                'width' => '100%;',
                'text' => function($row) { return $row['deviceUser']['devId']; },
                'route' => 'admin_devices_detail',
                'route_params' => function($row) {
                    return array(
                        'deviceId' => $row['deviceUser']['id'],
                    );
                },
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsFromArray($devices, 'id_device', 'devid'),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('deviceLastSeen.devId', LinkColumn::class, array(
                'title' => 'Dev. Last seen',
                'default_content' => '',
                'width' => '100%;',
                'text' => function($row) { return $row['deviceLastSeen']['devId']; },
                'route' => 'admin_devices_detail',
                'route_params' => function($row) {
                    return array(
                        'deviceId' => $row['deviceLastSeen']['id'],
                    );
                },
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsFromArray($devices, 'id_device', 'devid'),
                        'cancel_button' => true,
                    )
                ),
            ))

            /*->add('Devices_count', Column::class, array(
                'title' => 'Devices count',
                'width' => '100%;',
                'class_name' => 'row_devices_label_count',
                'dql' => '(SELECT COUNT({p}) FROM App:LabelDeviceMap {p} WHERE {p}.label = label.id)',
                'searchable' => true,
                'orderable' => true,
            ))*/
           ->add(null, ActionColumn::class, array(
               'title' => $this->translator->trans('sg.datatables.actions.title'),
               'width' => '100%;',
               'actions' => [
                   [
                       'route' => 'admin_tool_sim_cards_edit',
                       'route_parameters' => array(
                           'simCardId' => 'id',
                       ),
                       'label' => $this->translator->trans('sg.datatables.actions.edit'),
                       'icon' => self::ICON_EDIT,
                       'attributes' => array(
                           'rel' => 'tooltip',
                           'title' => $this->translator->trans('sg.datatables.actions.edit'),
                           'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                           'role' => 'button',
                           /*'data-toggle' => 'modal',
                           'id' => 'edit',
                           'data-target' => "#add-sim-card",*/
                       ),
                       'start_html' => '<div class="input-group">',
                   ],
                   [
                       'route' => 'ajax_sim_card_delete',
                       'route_parameters' => array(
                           'simCardId' => 'id',
                       ),
                       'label' => $this->translator->trans('sg.datatables.actions.delete'),
                       'icon' => self::ICON_DELETE,
                       'attributes' => array(
                           'rel' => 'tooltip',
                           'title' => $this->translator->trans('sg.datatables.actions.delete'),
                           'class' => 'btn btn-danger btn-xs mb-1',
                           'role' => 'button',
                           'data-toggle' => 'modal',
                           'id' => 'delete',
                           'data-target' => "#confirm-delete",
                       ),
                       'render_if' => function ($row) {
                           return $this->authorizationChecker->isGranted('ROLE_ADMIN');
                       },
                       'end_html' => '</div>',

                   ],

               ],
           ))

        ;
    }

}