<?php

namespace App\Repository;

use App\Entity\Snmp\Device;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\ArrayParameterType;
use Doctrine\DBAL\Result;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Device|null find($id, $lockMode = null, $lockVersion = null)
 * @method Device|null findOneBy(array $criteria, array $orderBy = null)
 * @method Device[]    findAll()
 * @method Device[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SnmpDeviceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Device::class);
    }

    public function removeSnmpDevice(int $deviceId): Result
    {

        $conn = $this->getEntityManager()->getConnection();

        $sql = 'DELETE FROM '. Device::ENTITY_TABLE_NAME . ' WHERE registered_as = :deviceId';
        $stmt = $conn->prepare($sql);
        return $stmt->executeQuery(['deviceId' => $deviceId]);


    }

}
