<?php

namespace App\Controller\Admin;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\DataTable\ConfigProfileDatatable;
use App\Form\ConfigProfile\ConfigProfileFromDeviceType;
use App\Form\ConfigProfile\ConfigProfileFromExistingProfileType;
use App\Repository\ConfigProfileRepository;
use App\Repository\DeviceRepository;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/config-profile', name: 'admin_config_profile_')]
class ConfigProfileController extends BaseController
{
    /**
     * @param Request $request
     * @param DatatableFactory $factory
     * @param DatatableResponse $responseService
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/', name: 'list')]
    public function configProfilesListAction(
        Request $request,
        DatatableFactory $factory,
        DatatableResponse $responseService,
		DeviceRepository $deviceRepository,
		ConfigProfileRepository $configProfileRepository
    ): Response {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $datatable = $factory->create(ConfigProfileDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

			$qb = $datatableQueryBuilder->getQb();
			$qb->andWhere('configprofile.directive = :directive');
			$qb->andWhere('configprofile.deleted = :deleted');
			$qb->setParameter('directive', true);
			$qb->setParameter('deleted', false);

            return $responseService->getResponse();
        }

		$devices = $deviceRepository->getDevicesWithAutomaticProfile();
		$profiles = $configProfileRepository->getProfilesToMakeCopy();
        $form = $this->createForm(ConfigProfileFromDeviceType::class, ['devices' => $devices]);
        $form2 = $this->createForm(ConfigProfileFromExistingProfileType::class, ['profiles' => $profiles]);

        return $this->render('configProfile/index.html.twig', [
            'datatable' => $datatable,
            'filter' => $this->filter,
            'form1' => $form->createView(),
            'form2' => $form2->createView()
            ]);
    }

}
