<?php

declare(strict_types=1);

namespace App\Service\Api;

final class DataSync extends ApiService
{

    public const CUSTOM_SCRIPT_TABLE_NAME_ID = 30;
    public const CUSTOM_SCRIPT_AGENT_PROFILE_MAP_TABLE_NAME_ID = 31;
    public const CUSTOM_SCRIPT_DEV_TYPE_MAP_TABLE_NAME_ID = 32;

    private const URL_API_SYNC = '/g/synch';

    /**
     * @return mixed
     * @throws \JsonException
     * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
     */
    public function syncCall(): mixed
    {

        return $this->getApiCall($this->baseUrl . self::URL_API_SYNC);

    }

    /**
     * @param int $deviceId
     * @return mixed
     * @throws \JsonException
     * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
     */
    public function syncCallByDeviceId(int $deviceId): mixed
    {

        return $this->getApiCall($this->baseUrl . self::URL_API_SYNC . '?alid=' . $deviceId);

    }

    public function syncCallByTableName(int $tableNameId): mixed
    {
        return $this->getApiCall($this->baseUrl . self::URL_API_SYNC . '?optid=0&nval=' . $tableNameId);

    }

}
