<?php

namespace App\Validator\Constraints;

use App\Entity\Tool\SimCard;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class IsUniqueInDbValidator extends ConstraintValidator
{

    public function __construct(private EntityManagerInterface $entityManager)
    {

    }
    public function validate($value, Constraint $constraint): void
    {
        if($constraint->getOptions() === $value){
            return;
        }

        if(empty($value)){
            return;
        }
        /*dump($value);
        dump($constraint->getOptions());
        die();*/
        $name = $constraint->getName();
        $simCard = $this->entityManager->getRepository(SimCard::class)->findBy([$name => $value]);

        if ($simCard) {
            $this->context->buildViolation($constraint->message)
                ->addViolation();
        }
    }


}
