<?php

declare(strict_types=1);

namespace App\Entity\Label;

use App\Entity\Device\Device;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'labels_map')]
#[ORM\UniqueConstraint(name: 'device_label', columns: ['id_device', 'id_label'])]
#[ORM\Entity]
class LabelDeviceMap
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var int
     */
    #[ORM\Column(name: 'id_label', type: Types::INTEGER)]
    private readonly int $labelId;

    /**
     * @var Label
     */
    #[ORM\ManyToOne(targetEntity: Label::class, inversedBy: 'devices')]
    #[ORM\JoinColumn(name: 'id_label', referencedColumnName: 'id')]
    public Label $label;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'labels')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return Label
     */
    public function getLabel(): Label {

        return $this->label;

    }

    /**
     * @return void
     */
    public function setLabel(Label $label): void {

        $this->label = $label;

    }

    /**
     * @return int
     */
    public function getLabelId(): int {

        return $this->labelId;

    }

    /**
     * @return Device
     */
    public function getDevice(): Device {

        return $this->device;

    }

    /**
     * @return void
     */
    public function setDevice(Device $device): void {

        $this->device = $device;

    }

}