<?php

namespace App\Repository;

use App\Entity\Product\ProductVersion;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method ProductVersion|null find($id, $lockMode = null, $lockVersion = null)
 * @method ProductVersion|null findOneBy(array $criteria, array $orderBy = null)
 * @method ProductVersion[]    findAll()
 * @method ProductVersion[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ProductVersionRepository extends ServiceEntityRepository
{

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductVersion::class);
    }

    /**
     * @return ProductVersion[]
     */
    public function getChangeLog(): array{

        return $this->findBy([], ['id' =>'desc']);

    }

    /**
     * @return ProductVersion
     */
    public function getProductVersion(): ProductVersion{

        return $this->findOneBy(['actual' => 1]);
    }

}
