<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_custom_fields')]
#[ORM\Entity]
class DeviceCustomField {

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $idDevice = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num1', type: Types::INTEGER, nullable: true)]
    public ?int $number1 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num2', type: Types::INTEGER, nullable: true)]
    public ?int $number2 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num3', type: Types::INTEGER, nullable: true)]
    public ?int $number3 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num4', type: Types::INTEGER, nullable: true)]
    public ?int $number4 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num5', type: Types::INTEGER, nullable: true)]
    public ?int $number5 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num6', type: Types::INTEGER, nullable: true)]
    public ?int $number6 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num7', type: Types::INTEGER, nullable: true)]
    public ?int $number7 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num8', type: Types::INTEGER, nullable: true)]
    public ?int $number8 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'num9', type: Types::INTEGER, nullable: true)]
    public ?int $number9 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt1', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text1 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt2', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text2 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt3', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text3 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt4', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text4 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt5', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text5 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt6', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text6 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt7', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text7 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt8', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text8 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'txt9', type: Types::STRING, length: 1024, nullable: true)]
    public ?string $text9 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo1', type: Types::FLOAT, nullable: true)]
    public ?float $float1 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo2', type: Types::FLOAT, nullable: true)]
    public ?float $float2 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo3', type: Types::FLOAT, nullable: true)]
    public ?float $float3 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo4', type: Types::FLOAT, nullable: true)]
    public ?float $float4 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo5', type: Types::FLOAT, nullable: true)]
    public ?float $float5 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo6', type: Types::FLOAT, nullable: true)]
    public ?float $float6 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo7', type: Types::FLOAT, nullable: true)]
    public ?float $float7 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo8', type: Types::FLOAT, nullable: true)]
    public ?float $float8 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'flo9', type: Types::FLOAT, nullable: true)]
    public ?float $float9 = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_update', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $lastUpdate;

    /**
     * @var Device
     */
    #[ORM\OneToOne(inversedBy: 'customFieldDevice', targetEntity: Device::class)]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device', nullable: true)]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->idDevice;
    }

    /**
     * @return int|null
     */
    public function getNumber1(): ?int
    {
        return $this->number1;
    }

    /**
     * @return int|null
     */
    public function getNumber2(): ?int
    {
        return $this->number2;
    }

    /**
     * @return int|null
     */
    public function getNumber3(): ?int
    {
        return $this->number3;
    }

    /**
     * @return int|null
     */
    public function getNumber4(): ?int
    {
        return $this->number4;
    }

    /**
     * @return int|null
     */
    public function getNumber5(): ?int
    {
        return $this->number5;
    }

    /**
     * @return int|null
     */
    public function getNumber6(): ?int
    {
        return $this->number6;
    }

    /**
     * @return int|null
     */
    public function getNumber7(): ?int
    {
        return $this->number7;
    }

    /**
     * @return int|null
     */
    public function getNumber8(): ?int
    {
        return $this->number8;
    }

    /**
     * @return int|null
     */
    public function getNumber9(): ?int
    {
        return $this->number9;
    }

    /**
     * @return string|null
     */
    public function getText1(): ?string
    {
        return $this->text1;
    }

    /**
     * @return string|null
     */
    public function getText2(): ?string
    {
        return $this->text2;
    }

    /**
     * @return string|null
     */
    public function getText3(): ?string
    {
        return $this->text3;
    }

    /**
     * @return string|null
     */
    public function getText4(): ?string
    {
        return $this->text4;
    }

    /**
     * @return string|null
     */
    public function getText5(): ?string
    {
        return $this->text5;
    }

    /**
     * @return string|null
     */
    public function getText6(): ?string
    {
        return $this->text6;
    }

    /**
     * @return string|null
     */
    public function getText7(): ?string
    {
        return $this->text7;
    }

    /**
     * @return string|null
     */
    public function getText8(): ?string
    {
        return $this->text8;
    }

    /**
     * @return string|null
     */
    public function getText9(): ?string
    {
        return $this->text9;
    }

    /**
     * @return float|null
     */
    public function getFloat1(): ?float
    {
        return $this->float1;
    }

    /**
     * @return float|null
     */
    public function getFloat2(): ?float
    {
        return $this->float2;
    }

    /**
     * @return float|null
     */
    public function getFloat3(): ?float
    {
        return $this->float3;
    }

    /**
     * @return float|null
     */
    public function getFloat4(): ?float
    {
        return $this->float4;
    }

    /**
     * @return float|null
     */
    public function getFloat5(): ?float
    {
        return $this->float5;
    }

    /**
     * @return float|null
     */
    public function getFloat6(): ?float
    {
        return $this->float6;
    }

    /**
     * @return float|null
     */
    public function getFloat7(): ?float
    {
        return $this->float7;
    }

    /**
     * @return float|null
     */
    public function getFloat8(): ?float
    {
        return $this->float8;
    }

    /**
     * @return float|null
     */
    public function getFloat9(): ?float
    {
        return $this->float9;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate(): \DateTime
    {
        return $this->lastUpdate;
    }

    /**
     * @return Device
     */
    public function getDevice(): Device
    {
        return $this->device;
    }



}
