<?php

declare(strict_types=1);

namespace App\Entity\Tool;

use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'sms_templates')]
#[ORM\Entity]
class SmsTemplate
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, length: 1, nullable: true)]
    public ?bool $targetAny = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, length: 1, nullable: true)]
    public ?bool $customizable = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 160, nullable: true)]
    public ?string $text = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 160, nullable: true)]
    public ?string $label = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, length: 1, nullable: true)]
    public ?bool $advantechCfg = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: Types::BOOLEAN, length: 1, nullable: true)]
    public ?bool $system = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: SmsHistory::class, mappedBy: 'smsTemplate', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $smsHistory;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string {

        return $this->label;

    }

    /**
     * @param string|null $label
     */
    public function setLabel(?string $label): void
    {
        $this->label = $label;
    }

}