<?php

declare(strict_types=1);

namespace App\Entity\CustomScript;

use App\Entity\AgentProfile\AgentProfile;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: ' custom_scripts_aprof_map ')]
#[ORM\Entity]
class CustomScriptAgentProfileMap
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var CustomScript
     */
    #[ORM\ManyToOne(targetEntity: CustomScript::class, inversedBy: 'agentProfileMap')]
    #[ORM\JoinColumn(name: 'script', referencedColumnName: 'id')]
    public CustomScript $script;

    /**
     * @var AgentProfile
     */
    #[ORM\ManyToOne(targetEntity: AgentProfile::class, inversedBy: 'scriptMap')]
    #[ORM\JoinColumn(name: 'agent_profile', referencedColumnName: 'id')]
    public AgentProfile $agentProfile;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_update', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $lastUpdate;

    public function __construct() {

        $this->lastUpdate = new \DateTime();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return AgentProfile
     */
    public function getAgentProfile(): AgentProfile
    {
        return $this->agentProfile;
    }

    /**
     * @param AgentProfile $agentProfile
     */
    public function setAgentProfile(AgentProfile $agentProfile): void
    {
        $this->agentProfile = $agentProfile;
    }

    /**
     * @return CustomScript
     */
    public function getScript(): CustomScript
    {
        return $this->script;
    }

    /**
     * @param CustomScript $script
     */
    public function setScript(CustomScript $script): void
    {
        $this->script = $script;
    }

}