# Shell functions for all scripts
# Not to be executed directly (no code should be executed here directly except variable definitions)

DEBUG=0

fail_fat() {
	echo "Fatal: " "$*" >&2
	ERR=$((ERR+1))
	exit 1
}

fail_nof() {
	ERR=$((ERR+1))
	echo "Error: " "$*" >&2
}

fail_noc() {
	echo "Error: " "$*" >&2
}

debug_start() {
	DEBUG=1
}

debug_stop() {
	DEBUG=0
}

debug_var() {
	[ $# -eq 0 ] && return
	[ $DEBUG -gt 0 ] && {
		echo -n "DEBUG var: $1 is "
		eval echo \$"$1"
	}
}

debug_cmd() {
	[ $# -eq 0 ] && return
	[ $DEBUG -gt 0 ] && {
		echo -n "DEBUG cmd: $*:"
		eval "$*"
	}
}

debug_txt() {
	[[ $# -gt 0 && $DEBUG -gt 0 ]] && echo "$*"
}

debug_pause() {
	[ $DEBUG -gt 0 ] && {
		[ $# -gt 0 ] && echo "DEBUG $* (press ENTER)" || echo "DEBUG pause (press ENTER)"
		read -r
	}
}

events_get_verbose() {
	[ -f "$BINDIR/db_init_basedata.sql" ] || {
		echo "Unable to log event as the deployment was not found." >&2
		return -1
	}
	cat "$BINDIR/db_init_basedata.sql" | sed "1,/^INSERT INTO log_event_type/d" | sed -n "1,/^$/p" | grep -v "^$" | grep "^([0-9]*, 3," | sed "s/^(\([0-9]*\),[^,]*,[ ]*'\([^']*\).*/\1 \2/"
}

events_get() {
	[ -f "$BINDIR/db_init_basedata.sql" ] || return -1
	cat "$BINDIR/db_init_basedata.sql" | sed "1,/^INSERT INTO log_event_type/d" | sed -n "1,/^$/p" | grep -v "^$" | sed "s/(\([0-9]*\).*/\1/" | grep "^([0-9]*, 3,"
	cat "$BINDIR/db_init_basedata.sql" | sed "1,/^INSERT INTO log_event_type/d" | sed -n "1,/^$/p" | grep -v "^$" | grep "^([0-9]*, 3," | sed "s/^(\([0-9]*\).*/\1/"
}

event_check() {
	[ $# -eq 1 ] || return -1
	EVLIST=$(events_get)
	for i in $EVLIST; do
		if [ "$i" = "$1" ] ; then
			return 0
		fi
	done
	return -1
}

event_log() {
	local MYSQOPT=${MYSQOPT:-}
	[ "$EUID" -eq 0 ] || { # if not running as root, try to source global site config and put together mysql options (password to database)"
		:
		[[ -n "$DWARFG_SITECONF" && -f "$DWARFG_SITECONF" ]] && {
			. "$DWARFG_SITECONF"
			[ -n "$DBPASS" ] && MYSQOPT="-p$DBPASS"
		}
	}
	[ $# -ge 1 ] || {
		echo "At least event (a number) must be specified. See event list below." >&2
		events_get_verbose >&2
		return -1
	}
	event_check "$1" || {
		echo "Invalid event" >&2
		return -1
	}
	SQLSPEC="(source, evtype"
	SQLVAL="(3, $1"
	shift
	while [ $# -gt 0 ] ; do
		TOK="$1"
		KEY=${TOK%%=*}
		VAL=${TOK#*=}
		case "$KEY" in
			MSG)
				SQLSPEC="$SQLSPEC, msg"
				SQLVAL="$SQLVAL, '$VAL'"
				;;
			VAL)
				[ "$VAL" = "${VAL//[^0-9]}" ] || {
					echo "VAL must be a number." >&2
					return -1
				}
				SQLSPEC="$SQLSPEC, value"
				SQLVAL="$SQLVAL, $VAL"
				;;
			EID)
				[ "$VAL" = "${VAL//[^0-9]}" ] || {
					echo "EID must be a number." >&2
					return -1
				}
				SQLSPEC="$SQLSPEC, extra_id"
				SQLVAL="$SQLVAL, $VAL"
				;;
			*)
				echo "Unsupported argument ($KEY)" >&2
				return -1
		esac
		shift
	done
	SQLSPEC="$SQLSPEC)"
	SQLVAL="$SQLVAL)"
	mysql $MYSQOPT $DWARFG_DBN -e "INSERT INTO log_events $SQLSPEC VALUES $SQLVAL;"
}

MYSQOPT=${MYSQOPT:-}
if [ -n "$MYSQL_PWD" ] ; then
	MYSQOPT="-p$MYSQL_PWD"
fi
export MYSQOPT
