<?php

namespace App\Form\ConfigProfile;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ConfigProfileFromExistingProfileType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

		$profiles = $options['data']['profiles'];
		$profilesChoices = [];

		foreach ($profiles as $item){

			$profilesChoices[$item['name']] = $item['id'];

		}

        $builder
            ->add('label', TextType::class, [
				'required' => false,
				'block_prefix' => 'modal_body'
			])
			->add('profile', ChoiceType::class, [
				'label' => 'Set from the existing profile',
				'required' => true,
				'choices' => $profilesChoices,
				//'choice_attr' => $deviceChoicesAttr,
				'placeholder' => 'Select a Profile',
				'data' => $options['data']['profile'] ?? null,
				'mapped' => false,
				'auto_initialize' => false,
				'attr' => ['data-row-class' => 'profile'], //Important to setup to send data from the form
				'block_prefix' => 'modal_body',
			])
            ->add('save', SubmitType::class, ['label' => 'Create Config Profile',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
	{

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}