<?php

declare(strict_types=1);

namespace App\Entity\Tunnel;

use App\Entity\Device\Device;
use App\Entity\Tunnel;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tunnels')]
#[ORM\Entity]
class Tunnels
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'webTunnels')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', length: 32, unique: true, nullable: true)]
    public ?string $url;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public int $devicePort;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $requestTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $expectedTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $setupTime;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: 'datetime', options: ['default' => null])]
    public \DateTime $lastTransfer;

    #[ORM\ManyToOne(targetEntity: Tunnel\TunnelStatus::class, inversedBy: 'tunnelStatuses')]
    #[ORM\JoinColumn(name: 'status')]
    public TunnelStatus $status;

    /**
     * @var TunnelOperation
     */
    #[ORM\ManyToOne(targetEntity: Tunnel\TunnelOperation::class, inversedBy: 'tunnelOperations')]
    #[ORM\JoinColumn(name: 'requested_op')]
    public TunnelOperation $requestedOperation;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    public ?bool $ssh;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getUrl(): ?string {

        return $this->url;

    }

    /**
     * @return Device
     */
    public function getDevice(): ?Device {

        return $this->device;

    }

    public function setDevice(Device $device): void
    {
        $this->device = $device;
    }

    /**
     * @return TunnelStatus
     */
    public function getStatus(): TunnelStatus {

        return $this->status;

    }

    /**
     * @return TunnelOperation
     */
    public function getRequestedOperation(): TunnelOperation {

        return $this->requestedOperation;

    }

    public function setRequestedOperation(TunnelOperation $requestedOperation): void {

        $this->requestedOperation = $requestedOperation;

    }

    /**
     * @return bool|null
     */
    public function getSsh(): ?bool
    {
        return $this->ssh;
    }

    /**
     * @param bool|null $ssh
     */
    public function setSsh(?bool $ssh): void
    {
        $this->ssh = $ssh;
    }

    public function isSsh(): bool
    {
        return $this->ssh;
    }

}