<?php

declare(strict_types=1);

namespace App\Entity\CustomScript;

use App\Entity\Device\DeviceType;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'custom_scripts_devtype_map ')]
#[ORM\Entity]
class CustomScriptDevTypeMap
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var CustomScript
     */
    #[ORM\ManyToOne(targetEntity: CustomScript::class, inversedBy: 'devTypeMaps')]
    #[ORM\JoinColumn(name: 'script', referencedColumnName: 'id')]
    public CustomScript $script;

    /**
     * @var DeviceType
     */
    #[ORM\ManyToOne(targetEntity: DeviceType::class, inversedBy: 'deviceTypeCustomScriptMappings')]
    #[ORM\JoinColumn(name: 'dev_type', referencedColumnName: 'id')]
    public DeviceType $devType;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_update', type: 'datetime', options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $lastUpdate;

    /**
     *
     */
    public function __construct() {

        $this->lastUpdate = new \DateTime();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return CustomScript
     */
    public function getScript(): CustomScript
    {
        return $this->script;
    }

    /**
     * @param CustomScript $script
     */
    public function setScript(CustomScript $script): void
    {
        $this->script = $script;
    }

    /**
     * @return DeviceType
     */
    public function getDevType(): DeviceType
    {
        return $this->devType;
    }

    /**
     * @param DeviceType $devType
     */
    public function setDevType(DeviceType $devType): void
    {
        $this->devType = $devType;
    }

}