<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_values')]
#[ORM\Entity]
class ConfigProfileValue
    {
    /**
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var ConfigProfile
     */
    #[ORM\ManyToOne(targetEntity: ConfigProfile::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'profile_id', referencedColumnName: 'id')]
    public ConfigProfile $profile;

    /**
     * @var ConfigProfileKey
     */
    #[ORM\ManyToOne(targetEntity: ConfigProfileKey::class, inversedBy: 'configValues')]
    #[ORM\JoinColumn(name: 'key_name', referencedColumnName: 'id')]
    public ConfigProfileKey $key;

    /**
     * @var string
     */
    #[ORM\Column(type: 'text', nullable: true)]
    public string $keyValue;

    /**
     * ConfigProfile constructor
     */
    public function __construct(){

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return ConfigProfile
     */
    public function getProfile(): ConfigProfile
    {
        return $this->profile;
    }

    /**
     * @param ConfigProfile $profile
     */
    public function setProfile(ConfigProfile $profile): void
    {
        $this->profile = $profile;
    }

    /**
     * @return ConfigProfileKey
     */
    public function getKey(): ConfigProfileKey
    {
        return $this->key;
    }

    /**
     * @param ConfigProfileKey $key
     */
    public function setKey(ConfigProfileKey $key): void
    {
        $this->key = $key;
    }

    /**
     * @return string
     */
    public function getKeyValue(): string
    {
        return $this->keyValue;
    }

    /**
     * @param string $keyValue
     */
    public function setKeyValue(string $keyValue): void
    {
        $this->keyValue = $keyValue;
    }

}