<?php

declare(strict_types=1);

namespace App\Controller\Admin\Ajax;

use App\Entity\CustomScript\CustomScript;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/admin/ajax/custom-script', name: 'ajax_custom_script_')]
class CustomScriptController extends Controller
{

    /**
     * Delete Custom script
     *
     * @param Request $request
     * @param int $customScriptId
     * @param ManagerRegistry $managerRegistry
     * @return Response
     */
    #[Route(path: '/delete/{customScriptId}', name: 'delete', methods: ['GET'])]
    public function customScriptDeleteAction(Request $request, int $customScriptId, ManagerRegistry $managerRegistry): Response {

        if ($request->isXmlHttpRequest()) {

            $customScript = $managerRegistry->getRepository(CustomScript::class)->findOneBy(['id' => $customScriptId]);

            if($customScript){

                try {
                    $em = $managerRegistry->getManager();
                    $em->remove($customScript);
                    $em->flush();

                }catch (\Exception $exception){

                    return new JsonResponse(['code' => 400, 'message' => 'Custom script cannot be deleted: ',
                        'errors' => ['Something bad happened.']],
                        200);

                }

                return new JsonResponse(['code' => 200, 'message' => 'Custom script "'. $customScript->getDescription() .'" was deleted.', 'success' => ''],
                    200);

            }

        }

        return new Response('Bad request.', 400);

    }

}