#!/bin/bash
SCRIPT="index.cgi"
SCRIPT_SET="set.cgi"
SRC="/opt/adwarfg/www/cgi_common.sh"

. $SRC

load_settings
[ -r "$WEBIMPORT" ] && . "$WEBIMPORT"
g_serverurl=${g_serverurl:-$DEF_SERVER}
echo "Content-type: text/html"
echo "Cache-Control: no-cache"
echo "Pragma: no-cache"
echo ""
echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">"
echo "<html>"
echo "<head>"
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">"
echo "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">"
echo "<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">"
echo "<title>Dwarfguard Agent</title>"
echo "<style type=\"text/css\">"
echo "<!--"
echo "body, table, tr, td, a {"
  echo "font-size: 12px; font-family: Verdana, Arial, Helvetica, sans-serif;"
echo "}"
echo "input, select, option, textarea, button {"
  echo "font-size: 13.3333px;"
echo "}"
echo "form, input {"
  echo "margin: 0px;"
echo "}"
echo "pre {"
  echo "margin: 10px 0px 10px 0px;"
echo "}"
echo "h2 {"
  echo "font-size: 24px; margin-bottom: 3px;"
echo "}"
echo "a {"
  echo "color: #004280; text-decoration: none;"
echo "}"
echo "a:hover {"
  echo "text-decoration: underline;"
echo "}"
echo ".logo {"
  echo "color: #004280; text-shadow: #B0C0E0 2px 2px 2px; filter: shadow(color=#B0C0E0, direction=145, strength=4);"
echo "}"
echo ".window {"
  echo "background-color: #F4F4F4; border: 2px solid #004280; border-collapse: collapse;"
echo "}"
echo ".title {"
  echo "color: #FFFFFF; background-color: #004280; font-weight: bold;"
echo "}"
echo ".header {"
  echo "color: #000000; background-color: #C0E0FF;"
echo "}"
echo ".input {"
  echo "width: 165px;"
echo "}"
echo "tr.spaceUnder>td {"
  echo "padding-bottom: 1em;"
echo "}"
echo "-->"
echo "</style>"
echo "</head>"
echo "<body bgcolor=\"#FFFFFF\">"
echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">"
  echo "<tr>"
    echo "<td nowrap class=\"logo\"><h2>Dwarfguard Agent</h2></td>"
  echo "</tr>"
echo "</table>"
echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">"
  echo "<tr>"
    echo "<td valign=\"top\" width=\"1%\">"
      echo "<table width=\"200\" cellspacing=\"0\" cellpadding=\"5\" border=\"2\" class=\"window\">"
      echo "<tr>"
          echo "<td nowrap class=\"title\">Status</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"index.cgi\">General Info</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
           echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"systemlogs.cgi\">System Logs</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td nowrap class=\"title\">Configuration</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"settings.cgi\">Global</a></td></tr>"
            echo "</table>"
          echo "</td>"
          echo "</tr>"
          echo "<tr>"
           echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"loglevels.cgi\">Log Levels</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td nowrap class=\"title\">General</td>"
        echo "</tr>"
        echo "<tr>"
          echo "<td>"
            echo "<table cellspacing=\"2\" cellpadding=\"1\">"
              echo "<tr><td nowrap><a href=\"../../module.cgi\">Return</a></td></tr>"
            echo "</table>"
          echo "</td>"
        echo "</tr>"
      echo "</table>"
    echo "</td>"
    echo "<td valign=\"top\" width=\"99%\">"
      echo "<form method=POST action=\"${SCRIPT_SET}\">"
      echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"2\" class=\"window\">"
        echo "<tr>"
          echo "<td align=\"center\" class=\"title\">Dwarfguard General Information</td>"
        echo "</tr>"
          echo "<tr>"
          echo "<td><table><tr class=\"spaceUnder\">"
          echo "<tr class=\"spaceUnder\"><td colspan=\"2\">"
          echo "<table class=\"settings\" style=\"word-break:break-all; word-wrap:normal; \">"
          echo "  <tbody><tr>"
          echo "  <td align=\"left\">Dwarfguard server URL/IP:"
          if [ -z "$g_serverurl" ] ; then
            echo "</td><td align=\"left\" style=\"color:red\"> URL is empty, agent initialization is probably not yet finished."
          fi
          echo "  </td><td align=\"left\"> <b>$g_serverurl</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td></tr>"
          echo "<tr>"
          echo " <td align=\"left\">Device Dwarfguard ID:"
          echo "  </td><td align=\"left\">" 
          if [ -z "$g_devid" ] ; then
            echo "<b>Not registered</>"
          else
            echo "<b>$g_devid</>"
          fi
          echo "</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td>"
          echo "</tr>"
          echo " <td align=\"left\">Agent version:"
          echo "  </td><td align=\"left\"> <b>$AGVER</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td>"
          echo "</tr>"
          echo " <td align=\"left\">Agent PID:"
          echo "  </td><td align=\"left\">" 
          OASTR="$AGENTPID"
          ASTR="$OASTR"
          COLORSTYLE=""
          if [[ -z "$AGENTPID" || 0 -eq "$AGENTPID" ]] ; then
            COLORSTYLE="style=\"color:red\""
            ASTR="Agent is not running..."
          else
            if [[ -n "$pcnt_errors" && "$pcnt_errors" -gt 0 ]] ; then
              COLORSTYLE="style=\"color:red\""
              ASTR="$ASTR, errors: $pcnt_errors"
            fi
            if [[ -n "$pcnt_connfails" && "$pcnt_connfails" -gt 0 ]] ; then
              [ -z "$COLORSTYLE" ] && COLORSTYLE="style=\"color:orange\""
              ASTR="$ASTR, connection errors: $pcnt_connfails"
            fi
          fi
          echo "<b $COLORSTYLE>$ASTR</>"
          echo "</>"
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td>"
          echo "</tr>"
          echo " <td align=\"left\">Next sync with server:"
          if [ -n "$time_target" ] ; then
            ATIME=$(date "+%T")
            echo "  </td><td align=\"left\"> <b>$time_target</> (localtime is $ATIME)"
          else
            echo "  </td><td align=\"left\"> time is being calculated..."
          fi
          echo "  </td><td align=\"left\"><span class=\"help-block\"></span>"
          echo "  </td>"
          echo "</tr>"
          echo "<tr>"
          echo " <td align=\"left\" style=\"padding-top: 10px;\"> Actions:"
          if [ 0 -eq "$AGENTPID" ] ; then
            echo "<br><p><input type=\"submit\" name=\"button\" value=\"Start Agent\">"
          else
            echo "<br><p><input type=\"submit\" name=\"button\" value=\"Stop Agent\">"
          fi
          if [ -n "$time_target" ] ; then
            echo "<input type=\"submit\" name=\"button\" value=\"Sync to server Now\"></p>"
          fi
          echo "  </td>"
          echo "</tr>"
          echo "</tbody></table>"
          # in there, status - registered/not registered, Dwarfguard device ID (e.g. ABBA), agent PID and server URL is to be shown
          # server URL change should lead to the connection menu item (below)
          echo "<ul><li>"
          if [ -z "$g_serverurl" ] ; then
            echo "<ul><li style=\"color:#ff0000\"> Agent initialization incomplete! </li>"
            echo "<li>Detected empty server URL. This typically means you are loading this page before agent initialization is complete. If you see this message more than a minute after agent installation, something went wrong. You may attempt setting the server URL <a href=\"settings.cgi\">in settings</a> but agent removal and new installation is usually a better option.</li></ul></li>"
          else
            echo "performing ping to $g_serverurl ... "
            if (test -n "$g_serverurl" && ping -c 1 "$g_serverurl" 2>/dev/null 1>&2); then
              echo "OK</li>"
              PINGOK="123"
            else
              echo "FAILED.</li>"
              PINGOK=""
            fi
            if [ -n "$PINGOK" ] ; then
              echo "<li> Dwarfguard service health check... "
              MRES=$(curl --connect-timeout 10 -k -s https://"$g_serverurl"/dwarfg/d/h)
              if [ $? -ne 0 ] ; then
                echo "FAILED (is Dwarfguard installed on $g_serverurl?).</li>"
              else
                MPID="${MRES%%/*}"
                if [ "$MPID" != "${MPID//[^0-9]}" ] ; then
                  echo "FAILED - invalid response (is Dwarfguard installed on $g_serverurl?).</li>"
                elif [ "$MPID" -eq 0 ] ; then
                  echo "FAILED - Dwarfguard daemon not running.</li>"
                else
                  echo "OK.</li>"
                fi
              fi
            fi
          fi
          echo "</ul>"
          echo "</pre></td></tr></table></td>"
          echo "</tr>"
        echo "</table>"
      echo "</form>"
    echo "</td>"
  echo "</tr>"
echo "</table>"
echo "</body>"
echo "</html>"
exit 0
