<?php

namespace App\Repository;

use App\Entity\DeviceOsVersion;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method DeviceOsVersion|null find($id, $lockMode = null, $lockVersion = null)
 * @method DeviceOsVersion|null findOneBy(array $criteria, array $orderBy = null)
 * @method DeviceOsVersion[]    findAll()
 * @method DeviceOsVersion[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DeviceOsVersionRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, DeviceOsVersion::class);
    }

    /**
     * @return int|mixed|string
     */
    public function getAvailableVersions(){

        $versions = $this->createQueryBuilder('ov')
            ->groupBy('ov.version')
            ->orderBy('ov.version')
            ->getQuery();

        return $versions->getResult();

    }

    public function getAvailableAndApprovedVersions(){

        $versions = $this->createQueryBuilder('ov')
            ->where('ov.available = 1')
            ->andWhere('ov.approved = 1')
            ->groupBy('ov.version')
            ->orderBy('ov.version')
            ->getQuery();

        return $versions->getResult();

    }

}
