<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_sync_statuses')]
#[ORM\Entity]
class DeviceSyncStatus
{

    final public const BEING_PROCESSED = 2;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $description;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\DeviceStats::class, mappedBy: 'syncStatus', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devicesStatus;

    /**
     * SyncStatus constructor.
     */
    public function __construct() {

        $this->devicesStatus = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->description;

    }

}