<?php

namespace App\DataTable\Column;


use Sg\DatatablesBundle\Datatable\Column\Column;

class CustomDateTimeColumn extends Column
{
    /**
     * {@inheritdoc}
     * @throws \Exception
     */
    public function renderSingleField(array &$row): static
    {

        $data = $row[$this->data];

        if ($data instanceof \DateTime) {
            $curDateTime = new \DateTime('NOW', new \DateTimeZone(date_default_timezone_get()));

            if ($curDateTime > $data) {
                $data = '<div style="color: red;">PASSED</div>';
            } else {
                $text = $this->ago($data);
                $data = '<b>' . $text . '</b>';
            }
        }

        $row[$this->data] = $data;

        return parent::renderSingleField($row);
    }

    /**
     * @param \DateTime $datetime
     * @return string
     */
    private function ago(\DateTime $datetime): string
    {
        $interval = date_create('now')->diff($datetime);
        $suffix = ( $interval->invert ? ' ago' : '' );
        $text = [];
        if ($v = ($interval->y >= 1)) {
            $text[] = $this->pluralize($interval->y, 'year') . $suffix;
        }
        if ($v = ($interval->m >= 1)) {
            $text[] = $this->pluralize($interval->m, 'month') . $suffix;
        }
        if ($v = ($interval->d >= 1)) {
            $text[] = $this->pluralize($interval->d, 'day') . $suffix;
        }
        if ($v = ($interval->h >= 1)) {
            $text[] = $this->pluralize($interval->h, 'hour') . $suffix;
        }
        if ($v = ($interval->i >= 1)) {
            $text[] = $this->pluralize($interval->i, 'minute') . $suffix;
        }
        $text[] = $this->pluralize($interval->s, 'second') . $suffix;

        return implode(', ', $text);
    }

    /**
     * @param int $count
     * @param string $text
     * @return string
     */
    private function pluralize(int $count, string $text): string
    {

        return $count . ( ( $count == 1 ) ? ( " $text" ) : ( " {$text}s" ) );
    }
}
