<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'monitoring_group_device_map')]
#[ORM\Entity]
class MonitoringGroupMapping
{

    final public const ENTITY_TABLE_NAME = 'monitoring_group_device_map';

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\Device::class, inversedBy: 'monitoringGroupMappings')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @var MonitoringGroup
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\MonitoringGroup::class, inversedBy: 'monitoringGroupMappings')]
    #[ORM\JoinColumn(name: 'mongrp_id', referencedColumnName: 'id')]
    public MonitoringGroup $monitoringGroup;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return Device
     */
    public function getDevice(): Device {

        return $this->device;

    }

    public function setDevice(Device $device){

        $this->device = $device;

    }

    /**
     * @return MonitoringGroup
     */
    public function getMonitoringGroup(): MonitoringGroup {

        return $this->monitoringGroup;

    }

    public function setMonitoringGroup(MonitoringGroup $monitoringGroup){

        $this->monitoringGroup = $monitoringGroup;

    }

}