#!/bin/bash

MYID="DB traffic rotate script"
BASEDEFS="base_defs"
FUNCS="deploy_funcs.sh"
MYSQOPT=${MYSQOPT:-}
tooold_days=120
debug=${debug:-}
export MYSQOPT

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR/$BASEDEFS" || { echo "Daily traffic counter: Fatal: Definition file ($DIR/$BASEDEFS) not found." >&2; exit 1; }
. "$DIR/$FUNCS" || { echo "$NAME traffic script: Fatal: Deploy functions ($DIR/$FUNCS) not found." >&2; exit 1; }
read_defs >/dev/null|| { echo "$NAME traffic script: Fatal: Cannot run read_defs()." >&2; exit 1; }
validate_deploy_commands || { echo "$NAME traffic script: Fatal: Cannot find mysql." >&2;exit 1; }

if [[ -z "$MYSQOPT" && -n "$DBPASS" ]] ; then
	MYSQOPT="-p$DBPASS"
fi

baseday=${baseday_in:-}
[ -z "$baseday" ] && baseday=$(date "+%F")
yesterday=$(date -d "$baseday -1 day" "+%F")
first_day=$(date -d "$baseday" "+%Y-%m-01")
#last_day=$(date -d "$(date +%Y-%m-01) + 1 month - 1 day" "+%F")
prev_first_day=$(date -d "$first_day - 1 day" "+%Y-%m-01")
prev_last_day=$(date -d "$first_day - 1 day" "+%F")
delete_day=$(date -d "$baseday - $tooold_days days" "+%F")
glob_out=""
glob_err=""

[ -n "$debug" ] && {
	echo "baseday: $baseday"
	echo "yesterday: $yesterday"
	echo "first_day: $first_day"
	echo "prev_first_day: $prev_first_day"
	echo "prev_last_day: $prev_last_day"
	echo "delete_day: $delete_day"
}

select_lastmonth_id="SELECT COUNT(id) FROM netdevs_monthly_traffic WHERE time='${prev_last_day}';"
daily_rotate="INSERT INTO netdevs_daily_traffic (netdev, tx_bytes, tx_bytes_totals, rx_bytes, rx_bytes_totals, time) SELECT t.netdev, d.tx_bytes-t.tx_bytes_totals, d.tx_bytes, d.rx_bytes-t.rx_bytes_totals, d.rx_bytes, '$yesterday' FROM device_netdevs d JOIN netdevs_daily_traffic t ON d.id = t.netdev WHERE t.time = (select MAX(t2.time) FROM netdevs_daily_traffic t2 WHERE t2.netdev = t.netdev);"
delete_old="DELETE FROM netdevs_daily_traffic WHERE time BETWEEN '1970-01-02' AND '$delete_day';"
monthly_save="INSERT INTO netdevs_monthly_traffic (netdev, tx_bytes, rx_bytes, time) SELECT t.netdev, SUM(t.tx_bytes), SUM(t.rx_bytes), '$prev_last_day' FROM netdevs_daily_traffic t WHERE t.time BETWEEN '$prev_first_day' AND '$prev_last_day' GROUP BY netdev";

sql_report_error() {
	echo "$NAME $MYID: sql error. Error output was: '$glob_err' and SQL was: '$1'"
}

sql_silent_exec() {
	[ -z "$C_MYSQL" ] && {
		echo "$NAME $MYID: mysql binary is not defined, unable to continue." >&2
		exit 1
	}
	[ -z "DWARFG_DBN" ] && {
		echo "$NAME $MYID: DB name is not defined, unable to continue." >&2
		exit 1
	}
	[ -z "$1" ] && {
		echo "$NAME $MYID: Empty sql. Internal error. Please report bug." >&2
		exit 1
	}
	tmpout=$(mktemp)
	glob_out=$($C_MYSQL $MYSQOPT "$DWARFG_DBN" -Nse "$1" 2>"$tmpout")
	myres=$?
	glob_err=$(cat "$tmpout")
	[ -n "$debug" ] && {
		echo "SQL: '$1'"
		echo "result: '$myres'"
		echo "stdout: '$glob_out'"
		echo "stderr: '$glob_err'"
	}
	rm "$tmpout"
	[[ $myres -ne 0 && $# -eq 1 ]] && {
		sql_report_error "$1"
		return 1
	}
	return 0
}

if sql_silent_exec "$select_lastmonth_id"; then
	lmid="$glob_out"
	sql_silent_exec "$daily_rotate" "noreport"
	[ -n "$glob_err" ] && {
		if echo "$glob_err" | grep "^ERROR 1062.*Duplicate entry.*netdev_daily_index" >/dev/null; then
			:
			# NOTE: when daily traffic from previous day exists, it is not considered error - just the script got executed twice, no big deal
		else
			sql_report_error "$daily_rotate"
		fi
	}
	if [ -n $lmid ] ; then
		[ "0" != "$lmid" ] && exit 0
		[ -n "$debug" ] && echo "Continuing with monthly rotation..."
		sql_silent_exec "$monthly_save" && sql_silent_exec "$delete_old"
	else
		echo "$NAME $MYID: monthly traffic SQL returned garbage, unable to continue." >&2
	fi
fi

