<?php

namespace App\Datatables;

use App\Entity\DeviceOsVersion;
use Sg\DatatablesBundle\Datatable\Column\BooleanColumn;
use Sg\DatatablesBundle\Datatable\Editable\SelectEditable;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class FirmwareDatatable
 * @package App\Datatables
 */
class FirmwareDatatable extends BaseDatatable
{

    protected string $entity = DeviceOsVersion::class;
    protected string $name = 'firmware_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        $osTypes = $options['osTypes'];
        $osVersions = $options['osVersions'];

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/firmware/addFirmware.js.twig',
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addFw',
                        'text' => '<i class=\"fa fa-plus\"></i> Add Firmware',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('osType.name', Column::class, array(
                'title' => 'Os Type',
                'width' => '100%;',
                'filter' => array(SelectFilter::class, array(
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($osTypes, 'name', 'name'),
                    'cancel_button' => true,
                ))
            ))
            ->add('version', Column::class, array(
                'title' => 'Version',
                'width' => '100%;',
                'filter' => array(SelectFilter::class, array(
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($osVersions, 'description', 'description'),
                    'cancel_button' => true,
                ))
            ))
            ->add('available', BooleanColumn::class, array(
                'title' => 'Available',
                'width' => '100%;',
                'true_label' => 'Yes',
                'false_label' => 'No',
                'true_icon' => 'fa fa-check green',
                'false_icon' => 'fa fa-times-circle red',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ),
                        'cancel_button' => true,
                    )
                ),
            ))
            ->add('approved', BooleanColumn::class, array(
                'title' => 'Approved',
                'default_content' => '',
                'width' => '100%;',
                'true_label' => ' Yes',
                'true_icon' => 'fa fa-check green',
                'false_icon' => 'fa fa-times-circle red',
                'false_label' => ' No',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ),
                        'cancel_button' => true,
                    )
                ),
                'editable' => array(SelectEditable::class,
                    array(
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                               // if ($row['createdBy']['id'] == $this->getUser()->getId() or true === $this->isAdmin()) {
                                    return true;
                               // };
                            }

                            return false;
                        },
                        'source' => array(
                            array('value' => 1, 'text' => 'Yes'),
                            array('value' => 0, 'text' => 'No'),
                        ),
                        'mode' => 'inline',
                        'empty_text' => '',
                    ),
                ),
            ))
            ->add('Devices_count', Column::class, array(
                'title' => 'Devices count',
                'width' => '100%;',
                'dql' => '(SELECT COUNT({p}) FROM App:Device {p} WHERE {p}.osVer = deviceosversion.id)',
                'searchable' => true,
                'orderable' => true,
            ))

        ;
    }

}