<?php

declare(strict_types=1);

namespace App\Entity;

use App\ValueObject\Configuration;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'product_conf')]
#[ORM\Entity]
class ProductConf
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var Configuration
     *
     */
    #[ORM\Column(type: 'app_config')]
    private string $name;

    /**
     * @var TypesValueType
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\TypesValueType::class, inversedBy: 'productConfigs')]
    #[ORM\JoinColumn(name: 'valtype')]
    public TypesValueType $valType;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public ?int $intval = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: 'float', nullable: true)]
    public ?float $floatval = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', nullable: true)]
    public ?string $strval = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public ?int $version = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'time', type: 'datetime', options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $time;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getName(): ?string {

        return $this->name;

    }

    public function setName(string $name): void{

        $this->name = $name;

    }

    /**
     * @return TypesValueType
     */
    public function getValType(): TypesValueType {

        return $this->valType;

    }

    public function setValType(TypesValueType $valType): void{

        $this->valtype = $valType;

    }

    /**
     * @return int
     */
    public function getIntval(): int {

        return $this->intval;

    }

    /**
     * @param int|null $value
     */
    public function setIntval(?int $value): void {

        $this->intval = $value;

    }

    /**
     * @return void
     */
    public function setBoolval(bool $value): void {

        $this->intval = (int) $value;

    }

    /**
     * @return float
     */
    public function getFloatval(): float {

        return $this->floatval;

    }

    /**
     * @param float|null $value
     */
    public function setFloatval(?float $value): void {

        $this->floatval = $value;

    }

    /**
     * @return string
     */
    public function getStrval(): ?string {

        return $this->strval;

    }

    /**
     * @param string|null $value
     */
    public function setStrval(?string $value): void {

        $this->strval = $value;

    }

    /**
     * @return int|null
     */
    public function getVersion(): ?int {

        return $this->version;

    }

    /**
     * @return \DateTime
     */
    public function getTime(): \DateTime {

        return $this->time;

    }

}