<?php

declare(strict_types=1);

namespace App\Entity\EventLog;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'log_event_type')]
#[ORM\Entity]
class EventType
{
    final public const START = 'Start';
    final public const CRITICAL_ERROR_DAEMON = 'Critical error (daemon)';
    final public const SHUTTING_DOWN = 'Shutting down';
    final public const NEW_DEVICE_CONNECTED = 'New device connected';
    final public const NEW_FW_AVAILABLE = 'New FW available';
    final public const FW_FILE_UPLOADED = 'FW file uploaded';
    final public const USER_DEFINED_ALERT = 'User-defined alert';
    final public const GENERAL_NOTICE = 'General notice';
    final public const LICENSING_ISSUE = 'Licensing issue';
    final public const PERFORMING_UPGRADE = 'Performing upgrade';
    final public const EVENTSYNC_DAEMON = 'Eventsync (daemon)';
    final public const DEVICE_AUTOPROFILE_UPDATE = 'Device autoprofile update';
    final public const TUNNEL_STATUS_UPDATE = 'Tunnel status update';
    final public const DAEMON_SPECIFIC_EVENT_1 = 'Daemon specific event 1';
    final public const USER_LOGIN = 'User login';
    final public const CRITICAL_ERROR_WEBUI = 'Critical error (WebUI)';
    final public const RESTART_REQUESTED = 'Restart requested';
    final public const DEVICE_CFG_USER_UPDATE = 'Device CFG user-update';
    final public const NEW_FW_VERSION_REQUESTED = 'New FW version requested';
    final public const ALERT_CONFIG_UPDATE = 'Alert config update';
    final public const LICENSE_UPLOADED = 'License uploaded';
    final public const UPGRADE_PKG_UPLOADED = 'Upgrade pkg uploaded';
    final public const EVENTSYNC_UI = 'Eventsync (UI)';
    final public const PROFILE_UPDATE = 'Profile update';
    final public const TUNNEL_CFG_UPDATE = 'Tunnel CFG update';
    final public const MONITORING_GROUP_UPDATE = 'Monitoring group update';
    final public const CFG_GROUP_UPDATE = 'CFG group update';

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'eventType', targetEntity: EventLog::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $events;

    /**
     * EventType constructor
     */
    public function __construct()
    {

        $this->events = new ArrayCollection();
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {

        return $this->name;
    }
}
