<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_models')]
#[ORM\Entity]
class DeviceModel {

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', length: 128, nullable: true)]
    public ?string $model = null;

    /**
     * @var Device
     */
    #[ORM\OneToOne(inversedBy: 'modelDevice', targetEntity: Device::class)]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id_device', nullable: true)]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

}
