#!/bin/bash

g_unupg=1
deb_version_file="/etc/debian_version"

houston() {
	echo -e "Run with exactly one argument:\n\trun ... install packages needed for run-time.\n\tbuild ... install packages needed for development.\n\tgrafana ... install Grafana OSS packages"
	exit 1
}

#-----------------------   build   -----------------------------
install_build_11() {
	apt-get -y install binutils make gawk g++ libmariadb-dev-compat vim tree slay rsync valgrind gdb manpages-dev libmariadb-dev python3 universal-ctags pylint3 libarchive-dev libssl-dev libjson-c-dev libbsd-dev libcurl4-openssl-dev
	return $?
}

install_build_12() {
	apt-get -y install binutils make gawk g++ libmariadb-dev-compat vim tree slay rsync valgrind gdb manpages-dev libmariadb-dev python3 universal-ctags pylint libarchive-dev libssl-dev libjson-c-dev libbsd-dev libcurl4-openssl-dev libffi8 libffi-dev
	return $?
}

# -----------------------  run/tests  -----------------------------

install_run_11() {
	apt-get -y install binutils apache2 mariadb-server slay python3 python3-mysqldb curl unzip sudo moreutils libapache2-mod-php php7.4 php7.4-pdo php7.4-mysql php7.4-mbstring php7.4-xml php7.4-intl php7.4-tokenizer php7.4-gd php7.4-imagick php7.4-curl php7.4-zip php7.4-bcmath mariadb-client rsync libjson-c5 libbsd0 libarchive13 sshpass
	res=$?
	[ $res -eq 0 ] || return $res
	systemctl enable apache2
	systemctl start apache2
	sleep 2
	return $?
}

install_run_12() {
	apt-get -y install binutils apache2 mariadb-server slay python3 python3-mysqldb curl unzip sudo libapache2-mod-php php8.2 php8.2-pdo php8.2-mysql php8.2-mbstring php8.2-xml php8.2-intl php8.2-tokenizer php8.2-gd php8.2-imagick php8.2-curl php8.2-zip php8.2-bcmath mariadb-client rsync libjson-c5 libbsd0 libarchive13 sshpass libffi8 jq pipx dropbear-bin influxdb influxdb-client
	res=$?
	[ $res -eq 0 ] || return $res
	systemctl enable apache2
	systemctl start apache2
	sleep 2
	return $?
}

install_build() {
	local deb_version=""
	if [ -f "$deb_version_file" ] ; then
		read -r -d . deb_version <"$deb_version_file"
		case "$deb_version" in
			"11")
				install_build_11
				;;
			"12")
				install_build_12
				;;
			*)
				echo "This script does not support the version of Debian GNU/Linux that was detected ($deb_version). You may try to look inside the script ($0) for a package list or call the install_build_11 or install_build_12 functions manually." >&2
				return 1
		esac
	else
		echo "ERR: The file $deb_version_file was not found. Installing on a non-Debian server is possible but not supported. Please look at the required packages inside $0 or retry installation on a Debian GNU/Linux machine." >&2
		return 1
	fi
}

install_run() {
	local deb_version=""
	if [ -f "$deb_version_file" ] ; then
		read -r -d . deb_version <"$deb_version_file"
		case "$deb_version" in
			"11")
				install_run_11
				;;
			"12")
				install_run_12
				;;
			*)
				echo "This script does not support the version of Debian GNU/Linux that was detected ($deb_version). You may try to look inside the script ($0) for a package list or call the install_run_11 or install_run_12 functions manually." >&2
				return 1
		esac
	else
		echo "ERR: The file $deb_version_file was not found. Installing on a non-Debian server is possible but not supported. Please look at the required packages inside $0 or retry installation on a Debian GNU/Linux machine." >&2
		return 1
	fi
}

install_grafana() {
	grafana_apt_conf="/etc/apt/sources.list.d/grafana.list"
	grafana_keyring_file="/etc/apt/keyrings/grafana.gpg"
	grafana_apt_url="https://apt.grafana.com"
	[ -f "$grafana_apt_conf" ] || {
		apt-get install -y apt-transport-https software-properties-common wget || return 1
		mkdir -p /etc/apt/keyrings/ || return 1
		wget -q -O - "$grafana_apt_url/gpg.key" | gpg --dearmor | sudo tee "${grafana_keyring_file}" > /dev/null || return 1
		echo "deb [signed-by=$grafana_keyring_file] $grafana_apt_url stable main" | sudo tee -a "$grafana_apt_conf"
		apt-get update
	}
	apt-get install -y grafana || return 1
	systemctl enable grafana-server
	systemctl start grafana-server
}

prerun() {
	systemctl --quiet is-enabled unattended-upgrades && {
		echo "Disabling unattended upgrades during installation..."
		g_unupg=0
		systemctl stop unattended-upgrades
		systemctl mask --runtime --now unattended-upgrades
		sleep 3
		systemctl stop unattended-upgrades
	}
}

postrun() {
	[ "$g_unupg" -eq 0 ] && echo "Enabling unattended upgrades..." && systemctl unmask unattended-upgrades
	g_unupg=1
}

trap postrun EXIT
PATH=/sbin:/usr/sbin:$PATH
if [ $# -eq 1 ] ; then
	case $1 in
		"run")
			prerun
			apt-get update
			install_run
			exit $?
			;;
		"build")
			prerun
			apt-get update
			install_build
			install_grafana
			exit $?
			;;
		"grafana")
			prerun
			install_grafana
			exit $?
			;;
		*)
			houston
	esac
else
	houston
fi

