<?php

declare(strict_types=1);

namespace App\Entity\Types;

use App\Entity\Alert\Alert;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'typetable_operators')]
#[ORM\Entity]
class TypesOperator
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'oper_txt', type: 'string', length: 10, unique: true, nullable: true)]
    public ?string $operatorText = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'oper_txt2', type: 'string', length: 10, unique: true, nullable: true)]
    public ?string $operatorText2 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'oper_txt3', type: 'string', length: 10, unique: true, nullable: true)]
    public ?string $operatorText3 = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public ?int $operands = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'operFirst', targetEntity: Alert::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'oper_first')]
    public Collection $alertsOperFirst;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'operSecond', targetEntity: Alert::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'oper_second')]
    public Collection $alertsOperSecond;

    /**
     * OperatorType constructor
     */
    public function __construct() {

        $this->alertsOperFirst = new ArrayCollection();
        $this->alertsOperSecond = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

    /**
     * @return string
     */
    public function getOperatorText(): string {

        return $this->operatorText;

    }

    /**
     * @return string
     */
    public function getOperatorText2(): ?string {

        return $this->operatorText2;

    }

    /**
     * @return string
     */
    public function getOperatorText3(): ?string {

        return $this->operatorText3;

    }

    public function getOperands(): int{

        return $this->operands;

    }

}