<?php

namespace App\Datatables;

use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class LabelDatatable
 * @package App\Datatables
 */
class CustomLabelDatatable extends BaseDatatable
{

    protected string $entity = \App\Entity\Label::class;
    protected string $name = 'labels_datatable';

    /**
     * @param array $options
     * @throws \Exception
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/label/createLabel.js.twig',
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addLabel',
                        'text' => '<i class=\"fa fa-plus\"></i> Create Label',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('label', Column::class, array(
                'title' => 'Label',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                if(true === $this->isAdmin()) {
                                    return true;
                                };
                            }

                            return false;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))
            ->add('Devices_count', Column::class, array(
                'title' => 'Devices count',
                'width' => '100%;',
                'class_name' => 'row_devices_label_count',
                'dql' => '(SELECT COUNT({p}) FROM App:LabelDeviceMap {p} WHERE {p}.label = label.id)',
                'searchable' => true,
                'orderable' => true,
            ))
           ->add(null, ActionColumn::class, array(
               'title' => $this->translator->trans('sg.datatables.actions.title'),
               'width' => '100%;',
               'actions' => array(
                   array(
                       'route' => 'admin_devices',
                       'route_parameters' => function($row){
                           return ['column[Labels]' => trim(urldecode(strip_tags($row['label'])))];
                       },
                       'label' => $this->translator->trans('sg.datatables.actions.list'),
                       'icon' => self::ICON_DETAIL,
                       'attributes' => array(
                           'rel' => 'tooltip',
                           'title' => $this->translator->trans('sg.datatables.actions.list'),
                           'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                           'role' => 'button',
                       ),
                       'start_html' => '<div class="input-group">',
                       'render_if' => function ($row) {
                           return $row['Devices_count'] > 0 && $this->authorizationChecker->isGranted('ROLE_ADMIN');
                       },

                   ),
                   array(
                       'route' => 'ajax_label_delete',
                       'route_parameters' => array(
                           'labelId' => 'id',
                       ),
                       'label' => $this->translator->trans('sg.datatables.actions.delete'),
                       'icon' => self::ICON_DELETE,
                       'attributes' => array(
                           'rel' => 'tooltip',
                           'title' => $this->translator->trans('sg.datatables.actions.delete'),
                           'class' => 'btn btn-danger btn-xs mb-1',
                           'role' => 'button',
                           'data-toggle' => 'modal',
                           'id' => 'delete',
                           'data-target' => "#confirm-delete",
                       ),
                       'render_if' => function ($row) {
                           return $this->authorizationChecker->isGranted('ROLE_ADMIN');
                       },
                       'end_html' => '</div>',

                   ),

               ),
           ))

        ;
    }

}