INSERT INTO agents (name, dir_name, package_name, minimal_version, dev_type, show_in_shortcut, description) VALUES
('Advantech routers', 'agent_advantech', 'adwarfg_advantech.tgz', '6.2.0', 2, true, 'Supports V2, V2i, V3 and V4 running ConelOS/ICR OS'),
("Teltonika routers - only monitoring", 'agent_teltonika', 'adwarfg_teltonika.ipk', NULL, 4, true, 'Monitoring only functionality, server certificate check is disabled.'),
("OpenWRT - only monitoring", 'agent_owrt', 'adwarfg_owrt.ipk', NULL, 3, true, 'Needs installing openssh-client for tunnels on the OpenWRT system, otherwise monitoring-only. Server certificate check is disabled.'),
('GNU/Linux (generic)', 'agent_linux', 'adwarfg_linux.tgz', NULL, 1, true, 'Generic Linux agent with systemd/initd integration. Cmdline installation.'),
("Teltonika routers - cmdline, mon. only", 'agent_teltonika', 'adwarfg_teltonika.tgz', NULL, 4, false, 'Cmdline install. Needs installing openssh-client for tunnels on the Teltonika system. Server certificate check is disabled.'),
("OpenWRT - cmdline, mon. only", 'agent_owrt', 'adwarfg_owrt.tgz', NULL, 3, false, 'Cmdline install. Needs installing openssh-client for tunnels on the OpenWRT system. Server certificate check is disabled.'),
("AAD - automated agent deployment tool", 'aad', 'push_agent.py', NULL, 1, false, 'A command-line level Python tool to automate mass device installation. See documentation before experimenting.');

INSERT INTO agent_device_type_map (agent_id, device_type_id) VALUES (1, 2), (2, 1), (3, 3), (4, 4), (1, 5);

INSERT INTO agent_versions (dev_type, version_major, version_minor, version_patchlevel, actual) VALUES
(1, 1, 0, 1, true),
(2, 1, 0, 1, true),
(3, 1, 0, 1, true),
(4, 1, 0, 1, true);

INSERT INTO product_versions (id, actual, version_major, version_minor, version_patchlevel, version_string, major, beta, notification, force_display, release_date, description) values 
(1, true, 1, 0, 3, 'Party patch3', false, false, true, true, '2025-06-06',
'<h5>Release notes</h5>'
'<h6>Server:</h6><ul>'
'<li>Catch and block invalid profile creation (e.g. when device provides invalid data).</li>'
'<li>Immediately exit on extremely slow I/O containers where local DB connection cannot be established in 10 seconds. (instead of partial failure).</li>'
'<li>Fix for Grafana integration with newer Grafana version.</li>'
'</ul><h6>Agents:</h6><ul>'
'</ul>');

INSERT INTO product_flags(id, version, description) values ('buildtag', 1, 'v1.0.3');
INSERT INTO product_flags(id, version, description) values ('about_info', 1, 'Dwarfguard - Monitoring, Alerting, Management and Automation System

Build tag: v1.0.3
Build date: 2025_09_10__09_30_23

Build components:
(mamas): v1.0.3
(mamasbig): v1.0.3
(mamasweb): v1.0.3
(mamasnotify): v1.0.3');
