<?php

namespace Unique\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Group Type.
 *
 * @author Lukas Krchnak <lukas.krchnak@uniqueweb.cz>
 */
class GroupType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'security.group_name',
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'save',
            ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
