<?php

namespace App\Repository;

use App\Entity\Alert\Alert;
use App\Entity\Device\FwFileName;
use App\Entity\EventLog\EventLog;
use App\Entity\EventLog\EventSource;
use App\Entity\EventLog\EventType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method EventLog|null find($id, $lockMode = null, $lockVersion = null)
 * @method EventLog|null findOneBy(array $criteria, array $orderBy = null)
 * @method EventLog[]    findAll()
 * @method EventLog[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EventLogRepository extends ServiceEntityRepository
{
    public const ACTION_CREATE = 'created';
    public const ACTION_UPDATE = 'updated';

    public const MESSAGE_ALERT_ENTITY = 'Alert was %s.';

    private EventTypeRepository $eventTypeRepository;
    private EventSourceRepository $eventSourceRepository;

    public function __construct(
        ManagerRegistry $registry,
        EventTypeRepository $eventTypeRepository,
        EventSourceRepository $eventSourceRepository
    ) {

        parent::__construct($registry, EventLog::class);

        $this->eventTypeRepository = $eventTypeRepository;
        $this->eventSourceRepository = $eventSourceRepository;
    }

    /**
     * @param string $entityName
     * @param int $entityId
     * @param string $action
     * @param string|null $message
     * @return EventLog
     * @throws \Exception
     */
    public function addEventLog(
        string $entityName,
        int $entityId,
        string $action,
        string $message = null,
        int $extraId = null,
    ): EventLog {

        if (!$message) {
            if ($entityName === Alert::class) {
                $eventTypeName = EventType::ALERT_CONFIG_UPDATE;
                $message = sprintf(self::MESSAGE_ALERT_ENTITY, $action);
            } else {
                throw new \RuntimeException('Not valid entity type given.');
            }
        }

        if ($entityName === FwFileName::class) {
            $eventTypeName = EventType::FW_FILE_UPLOADED;
        }

        $eventType = $this->eventTypeRepository->findOneBy(['name' => $eventTypeName]);
        $eventSource = $this->eventSourceRepository->findOneBy(['id' => EventSource::APP_WEBUI]);
        $eventLog = new EventLog();
        $eventLog->setEventType($eventType);
        $eventLog->setValue($entityId);
        $eventLog->setSource($eventSource);
        $eventLog->setExtraId($extraId);
        $eventLog->setMsg($message);

        return $eventLog;
    }

    public function persist(EventLog $eventLog): void
    {
        $this->getEntityManager()->persist($eventLog);
        $this->getEntityManager()->flush();
    }

}
