<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_key_groups')]
#[ORM\Entity]
class ConfigProfileKeyGroup
    {
    /**
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false)]
    public string $groupName;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'groupName', targetEntity: ConfigProfileKey::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $configProfileKeys;

    /**
     * ConfigProfile constructor
     */
    public function __construct(){

        $this->configProfileKeys = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getGroupName(): string
    {
        return $this->groupName;
    }

    /**
     * @return Collection
     */
    public function getConfigProfileKeys(): Collection
    {
        return $this->configProfileKeys;
    }

}