#!/bin/bash

BASEDEFS="base_defs"
ERR=0

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR/$BASEDEFS" || { echo "Fatal: Definition file ($BASEDEFS) not found."; exit 1; }
. "$DIR/$BASEFUNCS" || { echo "Fatal: Basic functions ($BASEFUNCS) not found."; exit 1; }

MYWDIR="/tmp/${SHORTNAME}_fwdown_$$"
CONDIRNAME=${FW_FLAVORS%% *}
TDIR="$SRVDIR_FW/$CONDIRNAME/$1"
MYOLDDIR=$(pwd)
URLBASE="https://icr.advantech.com/firmware"
COUNT=0

tidy_up() {
	cd "$MYOLDDIR"
	if [ 0 -eq "$ERR" ] ; then
		rm -rf "$MYWDIR" 2>/dev/null
	else
		event_log 301 "MSG=Errors during FW download: $ERR, not removing downloaded files."
	fi
}

cfail_fat() {
	tidy_up
	fail_fat $*
}

if [[ $# -eq 1  && "$1" != "-h" && "$1" != "--help" ]] ; then
	mkdir "$MYWDIR" || cfail_fat "Cannot mkdir temporary directory $MYWDIR"
	cd "$MYWDIR"
	if [ -f "$DWARFG_CACHE/$CONDIRNAME/$1/$FWDOWN_COMPLETE" ] ; then
		ln -s "$DWARFG_CACHE/$CONDIRNAME/$1" "$TDIR"
		COUNT=$(ls -1 "$DWARFG_CACHE/$CONDIRNAME/$1"|wc -l)
		COUNT=$((COUNT-1))
		event_log 305 MSG="Advantech FW version $1 (found in cache)."
		echo "${T_SCRRES_PREF}$COUNT FW files found in cache."
	else
		event_log 301 MSG="Starting FW download (ICR OS $1)."
		wget -r "$URLBASE/$1" -A gz,zip
		ECODE=$?
		ARCHIVES=$(find "$MYWDIR" -type f -name "*.zip" -o -type f -name "*.gz")
		CNT=$(echo -ne "$ARCHIVES" | grep -c "^")
		if [ "$CNT" -gt 0 ] ; then
			[ -d "$TDIR" ] || mkdir -m 0775 "$TDIR" || cfail_fat "Unable to make directory $TDIR for new firmware ($CNT files)"
			cd "$TDIR" || cfail_fat "Unable to access directory $TDIR"
			for i in $ARCHIVES
			do
				CUTFN=${i%zip} # strip "zip" string from end of $i
				OERR="$ERR"
				if [ "$i" == "$CUTFN" ] ; then # string is still the same, there is no "zip" string at the end
					tar xzf "$i" || fail_nof "Unable to extract file $i"
				else
					unzip -o "$i" || {
						if [ "$(basename "$i")" = "icr-324x.zip" ] ; then
							fail_noc "File $i is not a zip file (known error)"
						else
							fail_nof "Unable to extract file $i"
						fi
					}
				fi
				if [ "$ERR" -eq "$OERR" ] ; then
					COUNT=$((COUNT+1))
				fi
			done
			if [ 0 -eq "$ECODE" ] ; then
				touch "$FWDOWN_COMPLETE"
			else
				echo "Download using wget failed with return code $ECODE"
			fi
			echo "${T_SCRRES_PREF}$COUNT FW files unpacked."
			event_log 305 MSG="Advantech FW version $1."
		else
			cfail_fat "${T_SCRRES_PREF}0 zip files for the firmware $1 was downloaded"
		fi
		if [ -d "$DWARFG_CACHE" ] ; then
			rsync -a "$TDIR" "$DWARFG_CACHE/$CONDIRNAME/" && rm -r "$TDIR" && ln -s "$DWARFG_CACHE/$CONDIRNAME/$1" "$TDIR"
		fi
	fi
	tidy_up
else
	echo -e "\nAdvantech ICR OS based router FW download script: execute with one parameter - FW version.\n"
fi

