<?php

declare(strict_types=1);

namespace App\Service\Api;

use JsonException;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

final class ConfigProfiles extends ApiService
{

    private const PARAM_NVAL = 'nval';
    private const PARAM_DEVID = 'devid';

    private const URL_API_GET_CONFIG_PROFILE = '/g/cpget';
    private const URL_API_UPDATE_CONFIG_PROFILE = '/g/cpupd';
    private const URL_API_SET_CONFIG_PROFILE = '/g/cpset';

	/**
	 * @param int $deviceId
	 * @return mixed
	 * @throws JsonException
	 * @throws ClientExceptionInterface
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 * @throws DecodingExceptionInterface
	 */
    public function createConfigProfileByDeviceId(int $deviceId): mixed
    {

        $urlParams = self::PARAM_NVAL . '=' . '0&' . self::PARAM_DEVID . '=' . $deviceId;

		$jsonData = '{"Profile":[]}';

        return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
			$urlParams, $jsonData, true, false);

    }

	/**
	 * @param int $profileId
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws DecodingExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
	public function createConfigProfileByProfileId(int $profileId): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . '0&' . self::PARAM_NVAL . '=' . $profileId;

		return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
			$urlParams, null, true, false);

	}

	/**
	 * @param int $configProfileId
	 * @param array $deviceIds
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
    public function assignDeviceToConfigProfile(int $configProfileId, array $deviceIds): mixed{

        $urlParams = self::PARAM_NVAL . '=' . $configProfileId;
        //$urlParams .= '&'. self::PARAM_DEVID .'=' . '[' . implode(',',$deviceIds) . ']';
        foreach($deviceIds as $devId){
			$urlParams .= '&'. self::PARAM_DEVID .'=' . $devId;
		}

        return $this->getApiCall($this->baseUrl . self::URL_API_SET_CONFIG_PROFILE . '?' . $urlParams, true);

    }

	/**
	 * @param array $deviceIds
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
	public function unassignDeviceFromConfigProfile( array $deviceIds): mixed
	{

		$urlParams = self::PARAM_NVAL . '=0';
		$urlParams .= '&'. self::PARAM_DEVID .'=' . '[' . implode(',',$deviceIds) . ']';

		return $this->getApiCall($this->baseUrl . self::URL_API_SET_CONFIG_PROFILE . '?' . $urlParams, true);


	}

	/**
	 * @param int $profileId
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
	public function downloadConfigProfile(int $profileId): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . $profileId;

		/*dump($this->baseUrl . self::URL_API_GET_CONFIG_PROFILE . '?' .
			$urlParams);*/

		return $this->getApiCall($this->baseUrl . self::URL_API_GET_CONFIG_PROFILE . '?' .
			$urlParams, true);

	}

	/**
	 * @param string $jsonData
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws DecodingExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
	public function uploadConfigProfile(string $jsonData): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . 0;
		$urlParams .= '&'. self::PARAM_DEVID .'=' . 0;

		return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
			$urlParams, $jsonData, false, false);

	}

	/**
	 * @param int $profileId
	 * @param string $jsonData
	 * @return mixed
	 * @throws ClientExceptionInterface
	 * @throws DecodingExceptionInterface
	 * @throws JsonException
	 * @throws RedirectionExceptionInterface
	 * @throws ServerExceptionInterface
	 * @throws TransportExceptionInterface
	 */
	public function updateConfigProfile(int $profileId, string $jsonData): mixed
	{

		$urlParams = self::PARAM_NVAL . '=' . $profileId;

		return $this->postApiCall($this->baseUrl . self::URL_API_UPDATE_CONFIG_PROFILE . '?' .
		$urlParams, $jsonData, false, false);

	}

}